#ifndef __PBCASTVIEW_H__
#define __PBCASTVIEW_H__

#include "Interfaces/cView.h"
#include "Util/md5.h"

//
// CAUTION: There is *no* locking on this class.

class cPbcastNode;
class cPbcastView;

class cPbcastViewIterator : public cViewIterator
{
  public:
	  cPbcastViewIterator()	{ mIndex = 0; }
	  cPbcastViewIterator(cPbcastView* view) { mView = view; mIndex = 0; }
	  bool			Done();	
	  cEndpoint*	GetMember(); 
	  bool			GetNext();
	  unsigned int	GetNumMembers();
  private:
	unsigned int mIndex;
	cPbcastView *mView;
};

class cPbcastNodeIterator : public cIterator
{
 public:
	  cPbcastNodeIterator()	{ mIndex = 0; }
	  cPbcastNodeIterator(cPbcastView* view) { mView = view; mIndex = 0;}
	  bool			Done();	
	  cObject*		GetData(); 
	  bool			GetNext();
	  bool			DeleteCurrent();
  private:
	unsigned int mIndex;
	cPbcastView *mView;
};


class cPbcastView
{

 protected:

 public:
	friend class cPbcastViewIterator;
	friend class cPbcastNodeIterator;
	
	//Constructor(s)
	cPbcastView(unsigned int initialCap, unsigned int capInc);	

	//Destructor
	~cPbcastView();

	//Public Functions
	bool	Clear();				// Clears the view.
	int		GetNumElements()  { return mInsertPtr; }

	bool		 Delete(cPbcastNode* node);					// Removes that node from the view.
	bool		 Delete(cEndpoint* ep);						// Removes associated node from view.
	bool		 Insert(cPbcastNode* node);					// Inserts the node in the view.
	bool		 Find(cEndpoint* ep, cPbcastNode** result);	// Finds the given node in the view.
	cViewIterator*	 GetViewIterator() { mViewIter = cPbcastViewIterator(this); return &mViewIter; }
	cIterator*		 GetNodeIterator() { mNodeIter = cPbcastNodeIterator(this); return &mNodeIter; }
	cPbcastNode* GetNode(unsigned int i) { return mQueue[i]; }
	cPbcastNode* GetRandomNode();
	void		 UpdateDigest();
	bool		 GetDigest(unsigned char** digest, int* digestSize);
	bool		 FindEpOnSubnet(cEndpoint* ep, cEndpoint** outEp);

 private:
	int	 _BinSearch(cEndpoint* subnet, int left, int right);
	bool _Before(cEndpoint* a, cEndpoint* b);
	bool _Equal(cEndpoint* a, cEndpoint* b);
	bool _InsertSort();
	bool _Grow();		// Attempts to grow the view by at least one element, at most cap

	//Member Vars
	cPbcastNode** mQueue;
	unsigned int  mInsertPtr;
	unsigned int  mSize;
	unsigned int  mCapIncrement;
	cPbcastViewIterator mViewIter;
	cPbcastNodeIterator mNodeIter;
	unsigned char mDigest[DIGEST_SIZE];
};

#endif
